/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.api.handler.data.IMarcet;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.MarkupData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class PlayerGameData {
    private long money;
    public boolean updateClient;
    public boolean op = false;
    public final List<MarkupData> marketData = new ArrayList<MarkupData>();
    public double[] logPos;
    private final List<FollowerSet> followers = new ArrayList<FollowerSet>();
    public double blockReachDistance = 5.0;
    public double renderDistance = 128.0;
    public int dimID = 0;

    public FollowerSet addFollower(EntityNPCInterface npc) {
        FollowerSet fs = new FollowerSet(npc);
        this.followers.add(fs);
        return fs;
    }

    public void addMarkupXP(int marketID, int xp) {
        if (xp == 0) {
            return;
        }
        MarkupData md = this.getMarkupData(marketID);
        md.addXP(xp);
        IMarcet m = MarcetController.getInstance().getMarcet(marketID);
        if (m != null) {
            MarkupData d = ((Marcet)m).markup.get(md.level);
            if (md.level < ((Marcet)m).markup.size() - 1 && d != null && d.xp <= md.xp) {
                ++md.level;
                md.xp = 0;
            }
        }
        this.updateClient = true;
    }

    public void addMoney(long money) {
        this.money += money;
        if (this.money < 0L) {
            this.money = 0L;
        }
        this.updateClient = true;
    }

    public FollowerSet getFollower(EntityNPCInterface npc) {
        for (FollowerSet fs : this.followers) {
            if (!npc.equals((Object)fs.npc) && !fs.id.equals(npc.func_110124_au())) continue;
            return fs;
        }
        return null;
    }

    public List<FollowerSet> getFollowers() {
        return this.followers;
    }

    public int getMarcetLevel(int marketID) {
        return this.getMarkupData((int)marketID).level;
    }

    public MarkupData getMarkupData(int marketID) {
        MarkupData md = null;
        for (MarkupData m : this.marketData) {
            if (m.id != marketID) continue;
            md = m;
            break;
        }
        if (md == null) {
            md = new MarkupData(marketID, 0, 0);
            this.marketData.add(md);
        }
        return md;
    }

    public List<EntityNPCInterface> getMercenaries() {
        ArrayList<EntityNPCInterface> npcs = new ArrayList<EntityNPCInterface>();
        for (FollowerSet fs : this.followers) {
            if (fs.npc == null || fs.npc.field_70128_L) continue;
            npcs.add(fs.npc);
        }
        return npcs;
    }

    public long getMoney() {
        return this.money;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("Money", this.money);
        compound.func_74780_a("BlockReachDistance", this.blockReachDistance);
        compound.func_74780_a("RenderDistance", this.renderDistance);
        compound.func_74757_a("IsOP", this.op);
        NBTTagList markup = new NBTTagList();
        for (MarkupData data : this.marketData) {
            markup.func_74742_a(data.getPlayerNBT());
        }
        compound.func_74782_a("MarketData", (NBTBase)markup);
        if (this.logPos != null) {
            NBTTagList pos = new NBTTagList();
            for (double d : this.logPos) {
                pos.func_74742_a((NBTBase)new NBTTagDouble(d));
            }
            compound.func_74782_a("LoginPos", (NBTBase)pos);
        }
        NBTTagList fls = new NBTTagList();
        Object object = this.followers.iterator();
        while (object.hasNext()) {
            FollowerSet fs = (FollowerSet)object.next();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("UUID", fs.id.toString());
            nbt.func_74768_a("DimID", fs.dimId);
            fls.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Followers", (NBTBase)fls);
        return compound;
    }

    public String getTextMoney() {
        return Util.instance.getTextReducedNumber(this.money, true, true, false);
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound != null && compound.func_150297_b("GameData", 10)) {
            int i;
            NBTTagCompound gameNBT = compound.func_74775_l("GameData");
            this.money = gameNBT.func_74763_f("Money");
            if (compound.func_150297_b("BlockReachDistance", 6)) {
                this.blockReachDistance = compound.func_74769_h("BlockReachDistance");
            }
            if (compound.func_150297_b("RenderDistance", 6)) {
                this.renderDistance = compound.func_74769_h("RenderDistance");
            }
            this.op = gameNBT.func_74767_n("IsOP");
            if (gameNBT.func_150297_b("MarketData", 9)) {
                this.marketData.clear();
                for (i = 0; i < gameNBT.func_150295_c("MarketData", 10).func_74745_c(); ++i) {
                    NBTTagCompound nbt = gameNBT.func_150295_c("MarketData", 10).func_150305_b(i);
                    this.marketData.add(new MarkupData(nbt.func_74762_e("id"), nbt.func_74762_e("level"), nbt.func_74762_e("xp")));
                }
                this.logPos = null;
                if (gameNBT.func_150297_b("LoginPos", 9) && gameNBT.func_150295_c("LoginPos", 6).func_74745_c() > 3) {
                    NBTTagList list = gameNBT.func_150295_c("LoginPos", 6);
                    this.logPos = new double[]{list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2), list.func_150309_d(3)};
                }
            }
            if (gameNBT.func_150297_b("Followers", 9)) {
                this.followers.clear();
                for (i = 0; i < gameNBT.func_150295_c("Followers", 10).func_74745_c(); ++i) {
                    this.followers.add(new FollowerSet(gameNBT.func_150295_c("Followers", 10).func_150305_b(i)));
                }
            }
        }
    }

    public void removeFollower(EntityNPCInterface npc) {
        for (FollowerSet fs : this.followers) {
            if (!fs.id.equals(npc.func_110124_au())) continue;
            this.followers.remove(fs);
            return;
        }
    }

    public void removeFollower(FollowerSet fs) {
        this.followers.remove(fs);
    }

    public NBTTagCompound saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a("GameData", (NBTBase)this.getNBT());
        return compound;
    }

    public void setMoney(long money) {
        if (money < 0L) {
            money = 0L;
        }
        this.money = money;
        this.updateClient = true;
    }

    public static class FollowerSet {
        public UUID id;
        public int dimId;
        public EntityNPCInterface npc;

        public FollowerSet(EntityNPCInterface npc) {
            this.id = npc.func_110124_au();
            this.dimId = npc.field_70170_p.field_73011_w.getDimension();
            this.npc = npc;
        }

        public FollowerSet(NBTTagCompound nbt) {
            this.id = UUID.fromString(nbt.func_74779_i("UUID"));
            this.dimId = nbt.func_74762_e("DimID");
        }
    }
}

